(********************************************************************
 * PROGRAM: Lika
 * File: Lika.st
 * Author: Roberto Baricca
 * Created: August 04, 2015
 ********************************************************************
 * Implementation of program Lika
 ********************************************************************)

PROGRAM _CYCLIC
//	RETURN;  //ATTENZIONE : UN SOLO PROGRAMMA PUO' ESSERE ABILITATO ALLA VOLTA

	Real_Position:=Position;
	
	IF GlobalError=1 THEN 
		RETURN;
	END_IF
	
	IF SendPresetValue=0 THEN
		RETURN;  
	END_IF	
	
	CASE epl.state OF 	
	
		EPL_WAIT:  (*state to wait for user Commands*)
			epl.state := EPL_WRITE_OE;   
		EPL_WRITE_OE:  
			//==================== WRITE OBJECT ENTRY ========================
			epl.fub.EplSDOWrite_0.enable := 1;  (*enable the FUB*)
			epl.fub.EplSDOWrite_0.pDevice := ADR('IF3');  (*Device Name of Powerlink interface*)
			epl.fub.EplSDOWrite_0.node := 1;  (*Node Number of the Station to be read*)
			epl.fub.EplSDOWrite_0.index := 16#2211;  (*Write index *)
			epl.fub.EplSDOWrite_0.subindex := 0;  (*Subindex *)
			epl.fub.EplSDOWrite_0.pData:=ADR(PresetValue);(*pointer to the variable to be read*)
			epl.fub.EplSDOWrite_0.datalen:=SIZEOF(PresetValue);(*Length of the Data to be read*)
			
			IF epl.fub.EplSDOWrite_0.status = 0 THEN  
				(*writing successful*)	
				SendPresetValue:=0;
				epl.state := EPL_WAIT;
				epl.fub.EplSDOWrite_0.enable := 0;  (*disable the FUB*)	
				NumCycleWrite:=NumCycleWrite+1;
			ELSIF epl.fub.EplSDOWrite_0.status = ERR_FUB_BUSY THEN  
				(*Busy*)
			ELSIF epl.fub.EplSDOWrite_0.status = ERR_FUB_ENABLE_FALSE THEN  
				(*FUB is disabled*)
			ELSE  (*Go to error Step*)
				epl.state := EPL_ERROR;				
			END_IF
		EPL_ERROR:  
			(* Here some error Handling has to be implemented *)
			GlobalError:=1;
	END_CASE;	
	
	epl.fub.EplSDOWrite_0();  (*Call the EplSDOWrite_0 FUB*)

END_PROGRAM
